import {createRemoteComponent} from '@remote-ui/core';

export interface FormProps {
  /**
   * Whether the form is able to be submitted. When set to `true`, this will
   * disable the implicit submit behavior of the form.
   */
  disabled?: boolean;
  /**
   * A callback that is run when the form is submitted.
   */
  onSubmit(): void;
  /**
   * An optional override for the autogenerated form ID.
   */
  id?: string;
}

/**
 * The form component should be used to wrap one or more form controls. This
 * component provides an "implicit submit" behavior, where customers can submit
 * the form from any input by pressing "Enter" on their keyboards. This
 * behavior is widely expected, and should be respected as often as possible.
 *
 * Unlike an HTML `form` element, this component does not support configuring
 * the descendant fields to be submitted via HTTP automatically. Instead, you
 * must provide an `onSubmit` callback that will perform the necessary HTTP
 * requests in JavaScript.
 */
export const Form = createRemoteComponent<'Form', FormProps>('Form');
