import {createRemoteComponent} from '@remote-ui/core';

// Copied from https://github.com/Shopify/ui-api-design/blob/main/components/PaymentIcon/PaymentIcon.ts
export type PaymentMethod =
  | 'visa'
  | 'master'
  | 'discover'
  | 'american-express'
  | 'diners-club'
  | 'cartes-bancaires'
  | 'ing-homepay'
  | 'jcb'
  | 'rupay'
  | 'ethereum'
  | 'bitcoin'
  | 'monero'
  | 'dogecoin'
  | 'litecoin'
  | 'bitcoin-cash'
  | 'dash'
  | 'eos'
  | 'dai'
  | 'usdc'
  | 'apecoin'
  | 'solanapay'
  | 'bnbchain'
  | 'polygon'
  | 'depay'
  | 'busd'
  | 'gusd'
  | 'shib'
  | 'usdp'
  | 'wbtc'
  | 'xrp'
  | 'amazon'
  | 'boleto'
  | 'kbc-cbc'
  | 'sepa-bank-transfer'
  | 'dankort'
  | 'belfius'
  | 'dwolla'
  | 'tensile'
  | 'forbrugsforeningen'
  | 'giropay'
  | 'google-pay'
  | 'google-wallet'
  | 'opay'
  | 'laser'
  | 'paypal'
  | 'venmo'
  | 'sofort'
  | 'maestro'
  | 'unionpay'
  | 'visa-electron'
  | 'payfast-instant-eft'
  | 'mobicred'
  | 'payd'
  | 'airtel-money'
  | 'freecharge'
  | 'ola-money'
  | 'paytm'
  | 'mobikwik'
  | 'payzapp'
  | 'netbanking'
  | 'paysera'
  | 'citadele'
  | 'danske-bank'
  | 'krediidipank'
  | 'lhv'
  | 'op'
  | 'nordea'
  | 'seb'
  | 'swedbank'
  | 'dnb'
  | 'pps'
  | 'pivo'
  | 'masterpass'
  | 'mobilepay'
  | 'viabill'
  | 'novuna'
  | 'divido'
  | 'duologi'
  | 'klarna'
  | 'klarna-pay-now'
  | 'klarna-pay-later'
  | 'klarna-slice-it'
  | 'santander'
  | 'flexiti'
  | 'elv'
  | 'astrapay'
  | 'ideal'
  | 'interac'
  | 'arvato'
  | 'swish'
  | 'ratepay'
  | 'przelew24'
  | 'epayments'
  | 'paysafecard'
  | 'laybuy'
  | 'sezzle'
  | 'familymart'
  | '7-eleven'
  | 'lawson'
  | 'circle-k'
  | 'ministop'
  | 'sunkus'
  | 'daily-yamazaki'
  | 'mondido'
  | 'collector-bank'
  | 'apple-pay'
  | 'shopify-pay'
  | 'trustly'
  | 'ambank'
  | 'cimb'
  | 'hong-leong-bank'
  | 'maybank'
  | 'public-bank'
  | 'rhb-bank'
  | 'paymark-online-eftpos'
  | 'esr-paymentslip-switzerland'
  | 'twint'
  | 'elo'
  | 'hyper'
  | 'hypercard'
  | 'fpx'
  | 'atm-bersama'
  | 'bancnet'
  | 'eghl'
  | 'unipay'
  | 'mash'
  | 'jousto'
  | 'vipps'
  | 'krungsri'
  | 'uob'
  | 'siam-commercial'
  | 'enets'
  | 'grabpay'
  | 'eft-secure'
  | 'mpesa'
  | 'ovo'
  | 'mode'
  | 'wechat-pay'
  | 'spraypay'
  | 'bancontact'
  | 'in3'
  | 'v-pay'
  | 'ebucks'
  | 'pagoefectivo'
  | 'ozow'
  | 'eps'
  | 'affin-bank'
  | 'alliance-bank'
  | 'atobaraidotcom'
  | 'bank-islam'
  | 'bank-muamalat'
  | 'bank-rakyat'
  | 'bsn'
  | 'cimb-clicks'
  | 'deutsche-bank'
  | 'hong-leong-connect'
  | 'hsbc'
  | 'kuwait-finance-house'
  | 'maybankm2u'
  | 'ocbc-bank'
  | 'publicbank-pbe'
  | 'rhb-now'
  | 'standard-chartered'
  | 'afterpay'
  | 'clearpay'
  | 'cash-app-pay'
  | 'smartpay'
  | 'zapper'
  | 'payconiq'
  | 'paidy'
  | 'twig-pay'
  | 'stc-pay'
  | 'paynow'
  | 'bc-card'
  | 'hana-card'
  | 'hyundai-card'
  | 'kb-card'
  | 'lotte-card'
  | 'nh-card'
  | 'samsung-card'
  | 'shinhan-card'
  | 'kakao-pay'
  | 'kakebaraidotcom'
  | 'naver-pay'
  | 'payco'
  | 'samsung-pay'
  | 'toss'
  | 'coop'
  | 'luminor'
  | 'bdo'
  | 'bpi'
  | 'gcash'
  | 'afterpay-paynl-version'
  | 'naps'
  | 'benefit'
  | 'sadad'
  | 'mada'
  | 'kfast'
  | 'knet'
  | 'uae-visa'
  | 'fps'
  | 'line-pay'
  | 'rakuten-pay'
  | 'pay-easy'
  | 'merpay'
  | 'softbank'
  | 'givacard'
  | 'ymobile'
  | 'mtn-mobile-money'
  | 'fashioncheque'
  | 'airteltigo-mobile-money'
  | 'tendopay'
  | 'coinsph'
  | 'payu'
  | 'd-barai'
  | 'docomo-barai'
  | 'pay-pay'
  | 'blik'
  | 'billink'
  | 'au-kantan-kessai'
  | 'mb-way'
  | 'latitude-creditline-au'
  | 'latitude-gem-au'
  | 'latitude-gem-nz'
  | 'latitude-go-au'
  | 'mb'
  | 'bogus-app-coin'
  | 'postfinance-card'
  | 'postfinance-efinance'
  | 'alipay'
  | 'alipay-hk'
  | 'ask'
  | 'paymaya'
  | 'maya'
  | 'maya-bank'
  | 'qr-promptpay'
  | 'rcs'
  | 'bangkok-bank'
  | 'kasikornbank'
  | 'krungthai-bank'
  | 'thanachart-bank'
  | 'uob-thai'
  | 'bigc'
  | 'boost'
  | 'ecpay'
  | 'maybank-qrpay'
  | 'mcash'
  | 'rabbit-line-pay'
  | 'tesco-lotus'
  | 'touch-n-go'
  | 'payme'
  | 'payflex'
  | 'maxima'
  | 'alfamart'
  | 'alfamidi'
  | 'dan-dan'
  | 'indomaret'
  | 'dana'
  | 'linkaja'
  | 'shopeepay'
  | 'gopay'
  | 'bca'
  | 'bni'
  | 'bri'
  | 'mandiri'
  | 'permata'
  | 'bri-direct-debit'
  | 'octo-clicks'
  | 'brimo'
  | 'danamon-online'
  | 'bca-klikpay'
  | 'akulaku'
  | 'satispay'
  | 'qrph'
  | 'arhaus'
  | 'generalfinancing'
  | 'ubp'
  | 'farmlands'
  | 'qris'
  | 'axs'
  | 'sam'
  | 'facebook-pay'
  | 'meta-pay'
  | 'kueski-pay'
  | 'bread'
  | 'bread-pay'
  | 'payplan'
  | 'nelo'
  | 'vvv-giftcard'
  | 'kunst-en-cultuur-cadeaukaart'
  | 'nationale-bioscoopbon'
  | 'nationale-entertainmentcard'
  | 'podium-cadeaukaart'
  | 'webshop-giftcard'
  | 'billease'
  | 'lku'
  | 'rietumu'
  | 'affirm'
  | 'splitit'
  | 'zip'
  | 'humm'
  | 'synchrony'
  | 'satisfi'
  | 'checkout-finance'
  | 'n26'
  | 'echelon-financing'
  | 'acima-leasing'
  | 'synchrony-pay'
  | 'truemoney-pay'
  | 'gmo-postpay'
  | 'giftcard'
  | 'siauliu-bankas'
  | 'medicinos-bankas'
  | 'epospay'
  | 'poli'
  | 'perlasfinance'
  | 'directpay'
  | 'latitudepay'
  | 'genoapay'
  | 'poppankki'
  | 'revolut'
  | 'aktia'
  | 'saastopankki'
  | 'spankki'
  | 'walley'
  | 'atone'
  | 'addi'
  | 'omasp'
  | 'handelsbanken'
  | 'alandsbanken'
  | 'siirto'
  | 'scalapay'
  | 'aplazo'
  | 'paybylink'
  | 'snap-checkout'
  | 'fairstone-payments'
  | 'upi'
  | 'sveaeramaksu'
  | 'svea-part-payment'
  | 'svea-delbetalning'
  | 'svea-lasku'
  | 'svea-invoice'
  | 'svea-faktura'
  | 'svea-yrityslasku'
  | 'svea-b2b-invoice'
  | 'svea-b2b-faktura'
  | 'pix'
  | 'wegetfinancing'
  | 'anyday'
  | 'cleverpay'
  | 'payid'
  | 'uangme'
  | 'grailpay'
  | 'payto'
  | 'zinia'
  | 'fortiva'
  | 'fintecture'
  | 'hello-clever'
  | 'credit-key'
  | 'palawa'
  | 'palawan'
  | 'kredivo'
  | 'uob-ez-pay'
  | 'akulaku-paylater'
  | 'tandympayment'
  | 'paytomorrow'
  | 'bsi'
  | 'clave-telered'
  | 'credix'
  | 'sinpe-movil'
  | 'laybuy-heart'
  | 'lydia'
  | 'atome'
  | 'creditclick-paynl-version'
  | 'dropp'
  | 'cebuana'
  | 'futurepay-mytab'
  | 'biercheque-paynl-version'
  | 'swiftpay'
  | 'linkpay'
  | 'riverty-paynl-version'
  | 'wechat-paynl-version'
  | 'vvv-cadeaukaart-paynl-version'
  | 'przelewy24-paynl-version'
  | 'paysafecard-paynl-version'
  | 'gezondheidsbon-paynl-version'
  | 'fashion-giftcard-paynlversion'
  | 'alipay-paynl-version'
  | 'aftee'
  | 'momopay'
  | 'zalopay'
  | 'finloup'
  | 'billink-method'
  | 'oxxo'
  | 'spei'
  | 'bbva-cie'
  | 'alma'
  | 'svea-ostukonto'
  | 'svea-credit-account'
  | 'biller-paynl-version'
  | 'swissbilling'
  | 'bizum'
  | 'rcbc'
  | 'inbank'
  | 'ivy'
  | 'zoodpay'
  | 'valu'
  | 'tabby'
  | 'cliq'
  | 'postpay'
  | 'urpay'
  | 'hypercash'
  | 'fawry'
  | 'spotii'
  | 'tamara'
  | 'aqsat'
  | 'careem-pay'
  | 'billie'
  | 'sbpl'
  | 'coppel-pay'
  | 'sequra'
  | 'aeropay'
  | 'catch-payments'
  | 'openpay'
  | 'lbc'
  | 'atrato'
  | 'bss'
  | 'gmo-bank-transfer'
  | 'trevipay'
  | 'paypo'
  | 'younited-pay'
  | 'tabit'
  | 'etika'
  | 'mokka'
  | 'myfatoorah'
  | 'meeza'
  | 'paysafecash'
  | 'tbi-bank'
  | 'skrill-digital-wallet'
  | 'pei'
  | 'rapid-transfer'
  | 'neteller'
  | 'cetelem'
  | 'paid';

export interface PaymentIconProps {
  /**
   * The name of the payment method.
   *
   * Check the list of available payment methods [here](/docs/api/checkout-ui-extensions/components/media/paymenticon#paymentmethod).
   */
  name: PaymentMethod | string;

  /**
   * A label that describes the purpose or contents of the icon.
   *
   * When set, it will be announced to users using assistive technologies and will provide them with more context.
   * This should only be used if the icon requires an alternative internationalised label
   * or if it is otherwise inappropriate to make use of the default label included with the icon.
   */
  accessibilityLabel?: string;

  /**
   * Changes the visibility of the icon to assistive technologies.
   *
   * `hidden` hides the component from assistive technology (for example,
   * a screen reader) but remains visually visible.
   *
   * @defaultValue 'visible'
   */
  accessibilityVisibility?: 'hidden' | 'visible';
}

export const PaymentIcon = createRemoteComponent<
  'PaymentIcon',
  PaymentIconProps
>('PaymentIcon');
