import {
  Modal,
  BlockStack,
  Frame,
  TextField,
  InlineError,
} from "@shopify/polaris";
import { useState, useCallback, useEffect } from "react";
import { useAuthenticatedFetch } from "../hooks/useAuthenticatedFetch";
import { API_URL } from "../utils/apiUrls";
import { getShopName } from "../utils/shopName";
import SuccessToast from "../components/SuccessToast";
export default function AddComponent({
  addComponentActive,
  setAddComponentActive,
  value,
  handleChange,
  Components,
}) {
  const fetch = useAuthenticatedFetch();
  const [shop_name, setShop_name] = useState("");
  const [isLoading, setIsLoading] = useState(false);
  const [errorMsg, setErrorMsg] = useState([]);
  const [active, setActive] = useState(false);
  const toggleActive = useCallback(() => {
    setAddComponentActive((addComponentActive) => !addComponentActive);
    setErrorMsg("");
  }, []);

  const toggleActiveToast = useCallback(() => {
    setActive((active) => !active);
  }, []);
  const validation = () => {
    if (value.sku === "") {
      return "Component SKU is required";
    } else if (value.name === "") {
      return "Component name is required";
    } else if (value.qty == "") {
      return "Component Stock QTY is required";
    } else if (value.stock == "") {
      return "3 Month Stock Threshold is required";
    } else {
      return "success";
    }
  };
  console.log(errorMsg, "---");
  const addComponent = async () => {
    let validated = validation();
    if (validated != "success") {
      setErrorMsg([validated]);
    } else {
      setIsLoading(true);
      setErrorMsg("");

      const formData = new FormData();
      formData.append("component_name", value.name);
      formData.append("component_sku", value.sku);
      formData.append("component_stock_value", value.qty);
      formData.append("three_month_stock", value.stock);
      formData.append("shop_name", shop_name);

      try {
        const response = await fetch(API_URL.addComponent, {
          method: "POST",
          body: formData,
        });
        const data = await response.json();
        setIsLoading(false);
        if (data.status === "success") {
          toggleActiveToast();
          setTimeout(() => {
            toggleActive();
          }, 500);
          setTimeout(() => {
            Components(shop_name);
          }, 1000);
        } else {
          setErrorMsg(data.message);
        }
      } catch (err) {
        setIsLoading(false);
      }
    }
  };
  useEffect(() => {
    getShopName(fetch)
      .then((data) => {
        setShop_name(data.shop_name);
      })
      .catch((err) => {});
  }, [shop_name]);

  return (
    <div style={{ height: "500px" }}>
      <Frame>
        <Modal
          size="small"
          open={addComponentActive}
          onClose={toggleActive}
          title="Add Component"
          primaryAction={{
            content: "Save",
            loading: isLoading,
            onAction: addComponent,
          }}
          secondaryActions={[
            {
              content: "Cancel",
              onAction: toggleActive,
            },
          ]}
        >
          <Modal.Section>
            {errorMsg.length > 0 &&
              errorMsg.map((val, index) => {
                return <InlineError message={val} fieldID={index} />;
              })}
            <BlockStack gap={300} vertical>
              <TextField
                label="Component SKU"
                value={value.sku}
                onChange={(value) => handleChange(value, "sku")}
                autoComplete="off"
                id="component-sku"
              />
              <TextField
                label="Component Name"
                value={value.name}
                onChange={(value) => handleChange(value, "name")}
                autoComplete="off"
              />
              <TextField
                label="Component Stock QTY"
                value={value.qty}
                onChange={(value) => handleChange(value, "qty")}
                autoComplete="off"
              />
              <TextField
                label="3 Month Stock Threshold"
                value={value.stock}
                onChange={(value) => handleChange(value, "stock")}
                autoComplete="off"
              />
            </BlockStack>
          </Modal.Section>
        </Modal>
        {active && (
          <SuccessToast
            ToastMsg="Component Added Successfully"
            toggleActiveToast={toggleActiveToast}
          />
        )}
      </Frame>
    </div>
  );
}
