import { Frame, Modal, TextContainer } from "@shopify/polaris";
import { useCallback, useState, useEffect } from "react";
import SuccessToast from "./SuccessToast";
import ErrorToast from "./ErrorToast";
import { useAuthenticatedFetch } from "../hooks";
import { API_URL } from "../utils/apiUrls";
import { getShopName } from "../utils/shopName";
export function DeleteComponent({
    deleteComponentActive,
    setDeleteComponentActive,
    id,
    Components,
    data,
}) {
    const toggleActive = useCallback(() => {
        setDeleteComponentActive(
            (deleteComponentActive) => !deleteComponentActive
        ),
            [];
    });
    const [toastError, setToastError] = useState(false);
    const [loading, setLoading] = useState(false);
    const errorActiveToast = useCallback(
        () => setToastError((toastError) => !toastError),
        []
    );
    const [active, setActive] = useState(false);
    const [shop_name, setShop_name] = useState("");
    const toggleActiveToast = useCallback(() => {
        setActive((active) => !active);
    }, []);
    const fetch = useAuthenticatedFetch();
    const DeleteComponent = async () => {
        setLoading(true);
        try {
            const response = await fetch(`${API_URL.deleteComponent}?id=${id}`);
            const data = await response.json();
            setLoading(false);
            if (data.success == "true") {
                setTimeout(() => {
                    toggleActive();
                }, 500);
                setTimeout(() => {
                    Components(shop_name);
                }, 1000);
                toggleActiveToast();
            } else {
                errorActiveToast();
            }
        } catch (err) {
            setLoading(false);
            errorActiveToast();
        }
    };
    const DeleteOption = async () => {
        const formData = new FormData();
        formData.append("shop_name", shop_name);
        formData.append("option_id", id);
        setLoading(true);
        try {
            const response = await fetch(`${API_URL.deleteOption}`, {
                method: "POST",
                body: formData,
            });
            const data = await response.json();
            setLoading(false);
            if (data.status == "success") {
                setTimeout(() => {
                    toggleActive();
                }, 500);
                setTimeout(() => {
                    Components(shop_name);
                }, 1000);
                toggleActiveToast();
            } else {
                errorActiveToast();
            }
        } catch (err) {
            setLoading(false);
            errorActiveToast();
        }
    };

    useEffect(() => {
        getShopName(fetch)
            .then((data) => {
                setShop_name(data.shop_name);
            })
            .catch((err) => {});
    }, [shop_name]);
    return (
        <div style={{ height: "500px" }}>
            <Frame>
                <Modal
                    open={deleteComponentActive}
                    onClose={toggleActive}
                    title="Delete Component"
                    primaryAction={{
                        content: "Yes",
                        loading: loading,
                        onAction:
                            data == "Option" ? DeleteOption : DeleteComponent,
                    }}
                    secondaryActions={[
                        {
                            content: "Cancel",
                            onAction: toggleActive,
                        },
                    ]}
                >
                    <Modal.Section>
                        <TextContainer>
                            <p>Are You Sure Want To Delete??</p>
                        </TextContainer>
                    </Modal.Section>
                </Modal>
                {active && (
                    <SuccessToast
                        ToastMsg="Deleted Successfully"
                        toggleActiveToast={toggleActiveToast}
                    />
                )}
                {toastError && (
                    <ErrorToast
                        ToastMsg="Something Went Wrong"
                        errorActiveToast={errorActiveToast}
                    />
                )}
            </Frame>
        </div>
    );
}