import {
    TextField,
    IndexTable,
    Card,
    IndexFilters,
    useSetIndexFiltersMode,
    useIndexResourceState,
    Text,
    Page,
    useBreakpoints,
    Button,
    Box,
    BlockStack,
    Pagination,
    ButtonGroup,
} from "@shopify/polaris";

import { useState, useCallback, useEffect } from "react";
import { useNavigate } from "react-router-dom";

import { DeleteComponent } from "./DeleteComponent";
import { useFilteredData } from "../hooks";
export default function OptionsTable({ rows, getOption }) {
    const [active, setActive] = useState(false);
    const [totalPages, setTotalPages] = useState();
    const [id, setId] = useState("");
    const [currentPage, setCurrentPage] = useState(1);
    const navigate = useNavigate();
    const [activeDeleteModal, setActiveDeleteModal] = useState(false);
    const handleDeleteModalChange = useCallback(
        () => setActiveDeleteModal(!activeDeleteModal),
        [activeDeleteModal]
    );
    const PageSize = 5;
    const [selected, setSelected] = useState(0);

    const sortOptions = [
        {
            label: "none",
            value: "none asc",
            directionLabel: "A-Z",
        },
        {
            label: "none",
            value: "none desc",
            directionLabel: "Z-A",
        },
        {
            label: "Option Name",
            value: "option asc",
            directionLabel: "A-Z",
        },
        {
            label: "Option Name",
            value: "option desc",
            directionLabel: "Z-A",
        },
    ];
    const [sortSelected, setSortSelected] = useState(["none"]);
    const { mode, setMode } = useSetIndexFiltersMode();
    const onHandleCancel = () => {};

    const [queryValue, setQueryValue] = useState("");
    const handleFiltersQueryChange = useCallback(
        (value) => {
            setQueryValue(value);
            let filteredRows = rows.filter((item) =>
                item.option_name?.toLowerCase()?.includes(value.toLowerCase())
            );
            const totalPagesRounded = Math.ceil(filteredRows.length / PageSize);
            if (totalPagesRounded === 0) {
                setTotalPages(1);
                setCurrentPage(1);
            } else {
                setTotalPages(totalPagesRounded);
                setCurrentPage(1);
            }
        },

        [rows, PageSize, currentPage, totalPages]
    );
    const handleAccountStatusRemove = useCallback(
        () => setAccountStatus(undefined),
        []
    );
    const handleMoneySpentRemove = useCallback(
        () => setMoneySpent(undefined),
        []
    );
    const handleNext = () => {
        setCurrentPage((prevPage) => prevPage + 1);
    };
    const handlePrevious = () => {
        setCurrentPage((prevPage) => prevPage - 1);
    };
    const handleTaggedWithRemove = useCallback(() => setTaggedWith(""), []);
    const handleQueryValueRemove = useCallback(() => setQueryValue(""), []);
    const handleFiltersClearAll = useCallback(() => {
        handleAccountStatusRemove();
        handleMoneySpentRemove();
        handleTaggedWithRemove();
        handleQueryValueRemove();
    }, [
        handleAccountStatusRemove,
        handleMoneySpentRemove,
        handleQueryValueRemove,
        handleTaggedWithRemove,
    ]);
    useEffect(() => {
        const totalPagesRounded = Math.ceil(rows?.length / PageSize);
        if (totalPagesRounded === 0) {
            setTotalPages(1);
            setCurrentPage(1);
        } else {
            setTotalPages(Math.ceil(rows?.length / PageSize));
            setCurrentPage(1);
        }
    }, [PageSize, rows]);
    const resourceName = {
        singular: "order",
        plural: "rows",
    };
    const filteredData =
        rows.length > 0
            ? useFilteredData(
                  rows,
                  queryValue,
                  sortSelected,
                  currentPage,
                  PageSize
              )
            : [];
    const { selectedResources, allResourcesSelected, handleSelectionChange } =
        useIndexResourceState(filteredData);
    const rowMarkup = filteredData.map(({ id, option_name }, index) => (
        <IndexTable.Row
            id={id}
            key={id}
            selected={selectedResources.includes(id)}
            position={index}
        >
            <IndexTable.Cell>
                <Text>{option_name}</Text>
            </IndexTable.Cell>
            <IndexTable.Cell className="options_actions">
                <ButtonGroup>
                    <Button
                        onClick={() => {
                            navigate(`/edit/${id}`);
                        }}
                    >
                        Edit
                    </Button>

                    <Button
                        onClick={() => {
                            navigate(`/assignProducts/${id}`);
                        }}
                    >
                        Products Assign
                    </Button>

                    <Button
                        onClick={() => {
                            handleDeleteModalChange();
                            setId(id);
                        }}
                    >
                        Delete
                    </Button>
                </ButtonGroup>
            </IndexTable.Cell>
        </IndexTable.Row>
    ));

    return (
        <Page fullWidth>
            <div
                style={{
                    margin: "20px auto",
                    paddingLeft: "150px",
                    paddingRight: "150px",
                }}
            >
                <Card>
                    <IndexFilters
                        sortOptions={sortOptions}
                        sortSelected={sortSelected}
                        queryValue={queryValue}
                        queryPlaceholder="Searching in all"
                        onQueryChange={handleFiltersQueryChange}
                        onQueryClear={() => setQueryValue("")}
                        onSort={setSortSelected}
                        cancelAction={{
                            onAction: onHandleCancel,
                            disabled: false,
                            loading: false,
                        }}
                        tabs={[]}
                        selected={selected}
                        onSelect={setSelected}
                        canCreateNewView={false}
                        filters={[]}
                        appliedFilters={[]}
                        onClearAll={handleFiltersClearAll}
                        mode={mode}
                        setMode={setMode}
                    />
                    <IndexTable
                        condensed={useBreakpoints().smDown}
                        resourceName={resourceName}
                        selectable={false}
                        itemCount={filteredData.length}
                        selectedItemsCount={
                            allResourcesSelected
                                ? "All"
                                : selectedResources.length
                        }
                        onSelectionChange={handleSelectionChange}
                        headings={[
                            { title: "Option Name" },
                            { title: "Action", alignment: "center" },
                        ]}
                    >
                        {rowMarkup}
                    </IndexTable>
                    <Box padding={"300"}>
                        <BlockStack inlineAlign="center">
                            {rows?.length > PageSize && (
                                <Pagination
                                    hasPrevious={currentPage !== 1}
                                    onPrevious={handlePrevious}
                                    hasNext={totalPages > currentPage}
                                    onNext={handleNext}
                                />
                            )}
                        </BlockStack>
                    </Box>
                </Card>
            </div>

            {activeDeleteModal && (
                <DeleteComponent
                    deleteComponentActive={activeDeleteModal}
                    setDeleteComponentActive={setActiveDeleteModal}
                    id={id}
                    Components={getOption}
                    data="Option"
                />
            )}
        </Page>
    );
}
