export function useFilteredData(
    rows,
    queryValue,
    sortSelected,
    currentPage,
    PageSize
) {
    const firstPageIndex = (currentPage - 1) * PageSize;
    const lastPageIndex = firstPageIndex + PageSize;
    if (!rows || rows.length === 0) {
        return [];
    } else {
        const filterFunction = (item) => {
            const componentNameMatch =
                item?.component_name &&
                item.component_name
                    .toLowerCase()
                    .includes(queryValue.toLowerCase());
            const componentSkuMatch =
                item?.component_sku &&
                item?.component_sku
                    ?.toLowerCase()
                    ?.includes(queryValue.toLowerCase());
            const optionNameMatch =
                item?.option_name &&
                item?.option_name
                    ?.toLowerCase()
                    ?.includes(queryValue.toLowerCase());
            const productNameMatch =
                item?.product_name &&
                item?.product_name
                    ?.toLowerCase()
                    ?.includes(queryValue.toLowerCase());
            const componentStockMatch =
                item?.component_stock_value?.toString() &&
                item?.component_stock_value
                    ?.toString()
                    ?.toLowerCase()
                    ?.includes(queryValue.toLowerCase());
            return (
                queryValue === "" ||
                componentNameMatch ||
                componentSkuMatch ||
                componentStockMatch ||
                optionNameMatch ||
                productNameMatch
            );
        };

        function sortFunction(a, b) {
            if (sortSelected.length > 0) {
                if (sortSelected[0] == "none") {
                    return 0;
                }
                if (sortSelected[0] == "name asc") {
                    return a?.component_name?.localeCompare(b?.component_name);
                }
                if (sortSelected[0] === "name desc") {
                    return b?.component_name?.localeCompare(a?.component_name);
                }
                if (sortSelected[0] == "sku asc") {
                    return a?.component_sku?.localeCompare(b?.component_sku);
                }
                if (sortSelected[0] === "sku desc") {
                    return b?.component_sku?.localeCompare(a?.component_sku);
                }
                if (sortSelected[0] == "stock asc") {
                    return a?.component_stock_value - b?.component_stock_value;
                }
                if (sortSelected[0] === "stock desc") {
                    return b?.component_stock_value - a?.component_stock_value;
                }
                if (sortSelected[0] === "option asc") {
                    return a?.option_name?.localeCompare(b?.option_name);
                }
                if (sortSelected[0] === "option desc") {
                    return b?.option_name?.localeCompare(a?.option_name);
                }
                if (sortSelected[0] === "product asc") {
                    return a?.option_name?.localeCompare(b?.option_name);
                }
                if (sortSelected[0] === "product desc") {
                    return b?.product_name?.localeCompare(a?.product_name);
                }
            }
        }
        return rows
            ?.filter(filterFunction)
            ?.sort(sortFunction)
            ?.slice(firstPageIndex, lastPageIndex);
    }
}