import "./chunk-JUWXSDKJ.js";
import { parse as parseQuery } from "query-string";
const arrayBufferEquality = (a, b) => {
  if (!(a instanceof ArrayBuffer) || !(b instanceof ArrayBuffer))
    return void 0;
  const dataViewA = new DataView(a);
  const dataViewB = new DataView(b);
  if (dataViewA.byteLength !== dataViewB.byteLength)
    return false;
  for (let i = 0; i < dataViewA.byteLength; i++) {
    if (dataViewA.getUint8(i) !== dataViewB.getUint8(i))
      return false;
  }
  return true;
};
const blobEquality = (a, b) => {
  if (!(a instanceof Blob) || !(b instanceof Blob))
    return void 0;
  if (a.size !== b.size || a.type !== b.type) {
    return false;
  }
  return void 0;
};
const pluralize = (n, str) => {
  if (n === 1) {
    return `1 ${str}`;
  }
  return `${n} ${str}s`;
};
const isSpyInstance = (actual) => {
  if (typeof actual === "object" && actual && "spy" in actual && actual.spy._isMockFunction) {
    return true;
  }
  return false;
};
const assertSpy = (actual) => {
  if (!isSpyInstance(actual)) {
    throw new TypeError("expected value is not an instance of mockApi");
  }
};
const printApiCalls = (actual, print) => {
  return [
    "",
    "  API calls:",
    "",
    ...!actual.spy.calls.length ? ["No API calls"] : actual.spy.calls.map((args, i) => {
      return i + 1 + ". " + print(args);
    })
  ].join("\n");
};
function toFetch(actual) {
  assertSpy(actual);
  const calls = actual.getRouteCalls();
  const route = actual.getRoute();
  const pass = calls.length > 0;
  return {
    pass,
    message: () => {
      return [
        this.utils.matcherHint(`${this.isNot ? ".not" : ""}.toFetch`, "api", ""),
        "",
        "Expected:",
        `  Route "${this.utils.EXPECTED_COLOR(String(route))}" ${this.isNot ? "to never be called" : "to be called at least once"}.`,
        "Received:",
        printApiCalls(actual, this.utils.printReceived)
      ].join("\n");
    }
  };
}
function toFetchTimes(actual, times) {
  assertSpy(actual);
  const calls = actual.getRouteCalls();
  const route = actual.getRoute();
  const pass = calls.length === times;
  return {
    pass,
    message: () => {
      return [
        this.utils.matcherHint(`${this.isNot ? ".not" : ""}.toFetchTimes`, "api", "times"),
        "",
        "Expected:",
        `  Route "${this.utils.EXPECTED_COLOR(String(route))}" to have${this.isNot ? " not" : ""} been called ${pluralize(times, "time")}.`,
        "Received:",
        printApiCalls(actual, this.utils.printReceived)
      ].join("\n");
    }
  };
}
function bodyEquals(expectedBody, init, equals) {
  if (!init)
    return false;
  const body = init.body;
  if (!body)
    return false;
  if (typeof body === "string") {
    if (typeof expectedBody === "string")
      return body === expectedBody;
    try {
      return equals(JSON.parse(body), expectedBody);
    } catch {
      return false;
    }
  }
  if (typeof expectedBody === "string")
    return false;
  return equals(body, expectedBody, [arrayBufferEquality, blobEquality], true);
}
function toFetchWithBody(actual, expectedBody) {
  assertSpy(actual);
  const calls = actual.getRouteCalls();
  const route = actual.getRoute();
  const pass = calls.some(([, init]) => {
    return bodyEquals(expectedBody, init, this.equals);
  });
  return {
    pass,
    message: () => {
      return [
        this.utils.matcherHint(`${this.isNot ? ".not" : ""}.toFetchWithBody`, "api", "body"),
        "",
        "Expected:",
        `  Route "${this.utils.EXPECTED_COLOR(String(route))}" to have${this.isNot ? " not" : ""} been called with body ${this.utils.printExpected(expectedBody)}.`,
        "Received:",
        printApiCalls(actual, this.utils.printReceived)
      ].join("\n");
    }
  };
}
function toFetchNthTimeWithBody(actual, time, expectedBody) {
  assertSpy(actual);
  const calls = actual.getRouteCalls();
  const route = actual.getRoute();
  const pass = calls[time - 1] && bodyEquals(expectedBody, calls[time - 1][1], this.equals);
  return {
    pass,
    message: () => {
      return [
        this.utils.matcherHint(`${this.isNot ? ".not" : ""}.toFetchNthTimeWithBody`, "api", ""),
        "",
        "Expected:",
        `  Route "${this.utils.EXPECTED_COLOR(String(route))}" to have${this.isNot ? " not" : ""} been called ${time} time with body ${this.utils.printExpected(expectedBody)}.`,
        "Received:",
        printApiCalls(actual, this.utils.printReceived)
      ].join("\n");
    }
  };
}
function createQueryComparison(expectedQuery, equals) {
  const expectedQueryObj = typeof expectedQuery === "string" ? parseQuery(expectedQuery) : expectedQuery;
  return ([input]) => {
    const url = typeof input === "string" ? input : input.url;
    const uri = new URL(url);
    if (expectedQueryObj instanceof URLSearchParams) {
      return expectedQueryObj.toString() === uri.searchParams.toString();
    }
    return equals(expectedQueryObj, parseQuery(uri.search));
  };
}
function toFetchWithQuery(actual, expectedQuery) {
  assertSpy(actual);
  const calls = actual.getRouteCalls();
  const route = actual.getRoute();
  const queryEquals = createQueryComparison(expectedQuery, this.equals);
  const pass = calls.some(queryEquals);
  return {
    pass,
    message: () => {
      return [
        this.utils.matcherHint(`${this.isNot ? ".not" : ""}.toFetchWithQuery`, "api", "query"),
        "",
        "Expected:",
        `  Route "${this.utils.EXPECTED_COLOR(String(route))}" to have${this.isNot ? " not" : ""} been called with query:`,
        "",
        this.utils.printExpected(expectedQuery),
        "Received:",
        printApiCalls(actual, this.utils.printReceived)
      ].join("\n");
    }
  };
}
function toFetchNthTimeWithQuery(actual, time, expectedQuery) {
  assertSpy(actual);
  const calls = actual.getRouteCalls();
  const route = actual.getRoute();
  const queryEquals = createQueryComparison(expectedQuery, this.equals);
  const pass = calls[time - 1] && queryEquals(calls[time - 1]);
  return {
    pass,
    message: () => {
      return [
        this.utils.matcherHint(`${this.isNot ? ".not" : ""}.toFetchNthTimeWithQuery`, "api", ""),
        "",
        "Expected:",
        `  Route "${this.utils.EXPECTED_COLOR(String(route))}" to have${this.isNot ? " not" : ""} been called ${time} time with query:`,
        "",
        this.utils.printExpected(expectedQuery),
        "Received:",
        printApiCalls(actual, this.utils.printReceived)
      ].join("\n");
    }
  };
}
export {
  toFetch,
  toFetchNthTimeWithBody,
  toFetchNthTimeWithQuery,
  toFetchTimes,
  toFetchWithBody,
  toFetchWithQuery
};
