<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;

class DailyBackup extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'database:backup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'This command is used to do daily database backup';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $fileName = "backup-" . Carbon::now()->format('Y-m-d') . ".sql";

        $command = "mysqldump --user=" . escapeshellarg(env('DB_USERNAME')) . " --password=" . escapeshellarg(env('DB_PASSWORD')) . " --host=" . escapeshellarg(env('DB_HOST')) . " " . escapeshellarg(env('DB_DATABASE')) . " > " . storage_path() . "/app/backup/" . $fileName;

        $output = NULL;
        $returnVar = NULL;
        exec($command, $output, $returnVar);
    }

}
