<?php

namespace App\Console\Commands;

use App\Models\Products;
use App\Models\Session;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Shopify\Clients\Rest;

class PopulateProducts extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'PopulateProducts:command {shop}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    public $shop;
    public $token;

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try {

            $shop = $this->argument('shop');
            $accessToken = Session::where('shop', $shop)->value('access_token');
            $page_info = '';


            $client = new Rest($shop, $accessToken);
            do {
                $result = $client->get(path: 'products', query: ["limit" => "250", "page_info" => $page_info]);
                $products = $result->getDecodedBody();

                Log::info('Crone Job Started');
                foreach ($products['products'] as $product) {
                    $this->updateOrCreateThisProductInDB($product,$shop);
                }

                $serializedPageInfo = ($result->getPageInfo() == null) ? null : serialize($result->getPageInfo());

                Log::info(json_encode($serializedPageInfo));

                $pageInfo = ($serializedPageInfo == null) ? null : unserialize($serializedPageInfo);
                if ($pageInfo != null) {
                    $page_info = ($pageInfo->hasNextPage()) ?  $pageInfo->getNextPageQuery()['page_info'] : "";
                } else {
                    $page_info = "";
                }
            } while ($page_info != "");
        } catch (\Exception $e) {
            Log::info($e->getMessage());
        }
    }

    public function updateOrCreateThisProductInDB($product,$shop)
    {

        try {
            $payload = [
                'shop_name' => $shop,
                'product_id' => $product['id'],
                'product_name' => $product['title'],
                'body_html' => $product['body_html'],
                'vendor' => $product['vendor'],
            ];
            Products::updateOrCreate(['product_id' => $product['id']], $payload);
        } catch (\Exception $e) {
            Log::info($e->getMessage());
        }
    }
}
