<?php

namespace App\Http\Controllers;

use App\Exports\ComponentExport;
use App\Imports\ComponentImport;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class ImportComponentController extends Controller
{
    
    public function fileImport(Request $request) 
    {
        try{
            
            Excel::import(new ComponentImport, $request->file('file')->store('temp'));

            $response = [
                'status' => 'success',
                'message' => 'Components Import Successfully',
            ];
            return response()->json($response, 200);
        }
        catch(\Exception $e){
            return response()->json(['status_code' => 409, 'error' => 'Failed to Import Components', 'message' => $e->getMessage()], 409);
        }
    }
   
    public function fileExport() 
    {
        try{

            Excel::download(new ComponentExport, 'component-collection.xlsx');

            $response = [
                'status' => 'success',
                'message' => 'Components Export Successfully',
            ];
            return response()->json($response, 200);
        }
        catch(\Exception $e){
            return response()->json(['error' => 'Failed to Export Components', 'message' => $e->getMessage()], 500);
        }  
    }    
}
