<?php

namespace App\Jobs;

use App\Models\Component;
use App\Models\OptionProduct;
use App\Models\Session;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class TrackComponentQTY implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    public $body, $shop;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($body, $shop)
    {
        $this->body = $body;
        $this->shop = $shop;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $bodyData = $this->body;
        $shop = $this->shop;

        // Log::info('Order Data');
        // Log::info(json_encode($bodyData));

        $accessToken = Session::where('shop', $shop)->value('access_token');

        $lineItems = $bodyData['line_items'];
        $metaData = [];

        foreach ($lineItems as $lineItem) {

            $productID = $lineItem['product_id'];
            $checkExists = OptionProduct::where('product_id', $productID)->exists();
            if ($checkExists) {
                continue;
            }
            $metafieldURL =  "https://{$shop}/admin/api/2024-01/products/{$productID}/metafields.json";

            $response = Http::withHeaders([
                'X-Shopify-Access-Token' => $accessToken,
            ])->get($metafieldURL);

            $metaData[] = $response->json();
        }

        if (!empty($metaData)) {
            $this->updateInventoryInComponentDB($metaData, $lineItems);
        } else {
            Log::info('No MetaFeild Data is Found');
        }
    }

    public function updateInventoryInComponentDB($metaData, $lineItems)
    {
        try {

            $extractedData = collect([]);
            foreach ($metaData as $key => $item) {
        
                if (empty($item['metafields']) || !isset($item['metafields'][0]) || !array_key_exists('owner_id', $item['metafields'][0])) {
                    continue;
                }

                $ownerId = $item['metafields'][0]['owner_id'];

                $skuQtyPairs = [];
                foreach ($item['metafields'] as $metafield) {
                    $matches = [];
                    if (preg_match('/^component_(\d+)_sku$/', $metafield['key'], $matches)) {
                        $index = $matches[1];
                        $skuQtyPairs[$index]['SKU'] = $metafield['value'];
                    } elseif (preg_match('/^component_(\d+)_qty$/', $metafield['key'], $matches)) {
                        $index = $matches[1];
                        $skuQtyPairs[$index]['QTY'] = (float) $metafield['value'];
                    }
                }
                $extractedData[$ownerId] = collect($skuQtyPairs);
            }
            $componentInfo = $extractedData->toJson();

            $quantityInfo = [];
            foreach ($lineItems as $item) {
                $productId = $item['product_id'];
                $quantity = $item['quantity'];
                $quantityInfo[$productId] = [
                    'quantity' => $quantity
                ];
            }
            $array1 = json_decode($componentInfo, true);
            $array2 = $quantityInfo;

            foreach ($array2 as $key => $item2) {
                if (isset($array1[$key])) {
                    foreach ($array1[$key] as $subKey => $subValue) {
                        if (isset($item2['quantity'])) {
                            $array1[$key][$subKey]['QTY'] *= $item2['quantity'];
                        }
                    }
                }
            }

            foreach ($array1 as $key => $components) {
                foreach ($components as $component) {
                    $sku = $component['SKU'];
                    $qty = $component['QTY'];
                    $oldQuantity = Component::where('component_sku', $sku)->first()->component_stock_value;
                    $newQuantity = $oldQuantity - $qty;
                    Component::where('component_sku', $sku)->update(['component_stock_value' => $newQuantity]);
                }
            }
        } catch (\Exception $e) {
            Log::info($e->getMessage());
        }
    }
}
