<?php

namespace App\Jobs;

use App\Models\Component;
use App\Models\ComponentMiniProduct;
use App\Models\MiniProduct;
use App\Models\OptionMiniProduct;
use App\Models\Options;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class TrackOptionQTY implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    public $option, $quantity;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($option, $quantity)
    {
        $this->option = $option;
        $this->quantity = $quantity;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $option = $this->option;
        $quantity = $this->quantity;
        $miniProduct = $option['value'];
        $optionName = $option['name'];

        
        $optionDetails = Options::where('option_name',$optionName)
        ->with(['miniProducts', 'components'])
        ->first();
        if ($optionDetails) {
            $miniProductIds = collect($optionDetails->miniProducts)
            ->where('mini_product',$miniProduct)
            ->pluck('id')
            ->toArray();       
            if(!empty($miniProductIds)){
                $components = collect($optionDetails->components)->whereIn('mini_product_id',$miniProductIds)->toArray();
                foreach(array_merge($components) as $component){
                        $lookupAssignedQuantity = $component['quantity'];
                        $componentId = $component['component_id']; 
                        $oldstockValue = Component::where('id', $componentId)->first()->component_stock_value;
                        $newstockValue = $oldstockValue - $lookupAssignedQuantity * $quantity;
                        Component::where('id', $componentId)->update(['component_stock_value' => $newstockValue]);
                    }
                }
        }
    }
}
