<?php

namespace App\Jobs;

use App\Jobs\TrackComponentQTY;
use App\Jobs\TrackOptionQTY;
use App\Models\OptionMiniProduct;
use App\Models\OptionProduct;
use App\Models\Options;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class TrackQTY implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    public $body, $shop;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($body, $shop)
    {
        $this->body = $body;
        $this->shop = $shop;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $body = $this->body;
        $shop = $this->shop;
        $lineItems = $body['line_items'];

        $optionArr = Options::pluck('option_name')->toArray();
        $flag = true;              

        foreach ($lineItems as $lineItem) {   
            Log::info(json_encode($lineItem));   
            $options = $lineItem['properties'];
            Log::info(json_encode($options));
            $quantity = $lineItem['quantity'];
            $productId = $lineItem['product_id'];
            if (count($options) > 0) {
                
                foreach ($options as $option) {
                    $optionFromDB = Options::where('option_name', $option['name'])->first();
                    $checkExists =  OptionProduct::where('option_id', $optionFromDB->id)->where('product_id', $productId)->exists();
                    if ($checkExists) {
                        if (in_array($option['name'], $optionArr)) {
                            Log::info('Track Option QTY');
                            TrackOptionQTY::dispatch($option, $quantity);
                        }
                    }
                    else{
                        if($flag){
                            Log::info('Track Component QTY ----1');
                            TrackComponentQTY::dispatch($body, $shop);
                            $flag = false;
                        }
                    }
                }
            } else {
                Log::info('Track Component QTY ----2');
                TrackComponentQTY::dispatch($body, $shop);
                break;
            }
        };
    }
}
