<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasManyThrough;

class Options extends Model
{
    use HasFactory;
    protected $fillable = [
        'shop_name',
        'option_name',
    ];

    public function miniProducts()
    {
        return $this->belongsToMany(MiniProduct::class, 'option_mini_products', 'option_id', 'mini_product_id');
    }
    public function components()
    {
        return $this->hasManyThrough(
            ComponentMiniProduct::class,
            OptionMiniProduct::class,
            'option_id',
            'mini_product_id',
            'id',
            'id'
        )->with('component');
    }
}
