<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateComponentMiniProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('component_mini_products', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('mini_product_id'); 
            $table->foreign('mini_product_id')->references('id')->on('mini_products')->onDelete('cascade');
            $table->index('mini_product_id');
            $table->unsignedBigInteger('component_id'); 
            $table->foreign('component_id')->references('id')->on('components')->onDelete('cascade');
            $table->index('component_id');
            $table->decimal('quantity', 10, 4)->default(0.0000);
            $table->timestamps();
        });  
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('component_mini_products');
    }
}
