import { useState, useCallback, useEffect } from "react";
import {
    Frame,
    Modal,
    FormLayout,
    TextField,
    InlineError,
} from "@shopify/polaris";
import { useAuthenticatedFetch } from "../hooks";
import { API_URL } from "../utils/apiUrls";
import { getShopName } from "../utils/shopName";
import SuccessToast from "./SuccessToast";

export default function AddOption({ active, setActive, getOption }) {
    const [value, setValue] = useState("");
    const fetch = useAuthenticatedFetch();
    const [isLoading, setIsLoading] = useState(false);
    const [errorMsg, setErrorMsg] = useState([]);
    const [shop_name, setShop_name] = useState("");
    const [toggleActive, settoggleActive] = useState(false);
    const handleChange = useCallback(() => {
        setErrorMsg([]);
        setValue("");
        setActive(!active), [active];
    });
    const toggleActiveToast = useCallback(() => {
        settoggleActive((toggleActive) => !toggleActive);
    }, []);
    const validation = () => {
        if (value === "") {
            return "Option Name is required";
        } else {
            return "success";
        }
    };
    const addOption = async () => {
        let validated = validation();
        if (validated != "success") {
            setErrorMsg([validated]);
        } else {
            setIsLoading(true);
            setErrorMsg([]);
            const formData = new FormData();
            formData.append("shop_name", shop_name);
            formData.append("option_name", value);
            try {
                const response = await fetch(API_URL.addOption, {
                    method: "POST",
                    body: formData,
                });
                setIsLoading(false);
                const data = await response.json();
                if (data.status === "success") {
                    toggleActiveToast();
                    getOption(shop_name);
                    setTimeout(() => {
                        handleChange();
                    }, 500);
                } else {
                    setErrorMsg(data.message);
                }
            } catch (err) {

            }
        }
    };

    useEffect(() => {
        getShopName(fetch)
            .then((data) => {
                setShop_name(data.shop_name);
            })
            .catch((err) => {});
    }, [shop_name]);
    const handleValueChange = useCallback((newValue) => setValue(newValue), []);
    return (
        <div style={{ height: "500px" }}>
            <Frame>
                <Modal
                    open={active}
                    onClose={() => {
                        handleChange();
                    }}
                    title="Add Option"
                    primaryAction={{
                        content: "Add",
                        onAction: addOption,
                        loading: isLoading,
                    }}
                    secondaryActions={[
                        {
                            content: "Cancel",
                            onAction: handleChange,
                        },
                    ]}
                >
                    <Modal.Section>
                        {errorMsg?.length > 0 &&
                            errorMsg?.map((val, index) => {
                                return (
                                    <InlineError
                                        message={val}
                                        fieldID={index}
                                    />
                                );
                            })}
                        <FormLayout>
                            <TextField
                                label="Option Name"
                                value={value}
                                onChange={handleValueChange}
                                autoComplete="off"
                            />
                        </FormLayout>
                    </Modal.Section>
                </Modal>
                {toggleActive && (
                    <SuccessToast
                        ToastMsg="Option Added Successfully"
                        toggleActiveToast={toggleActiveToast}
                    />
                )}
            </Frame>
        </div>
    );
}
