import {
    Modal,
    DropZone,
    Checkbox,
    Frame,
    BlockStack,
    LegacyStack,
    Thumbnail,
    InlineError,
} from "@shopify/polaris";
import { useState, useCallback, useEffect } from "react";
import { NoteIcon } from "@shopify/polaris-icons";
import { useAuthenticatedFetch } from "../hooks";
import { API_URL } from "../utils/apiUrls";
import SuccessToast from "./SuccessToast";
import ErrorToast from "./ErrorToast";
import { getShopName } from "../utils/shopName";
export default function ImportComponent({ active, setActive, Components }) {
    const [checked, setChecked] = useState(false);
    const [toastActive, setToastActive] = useState(false);
    const [shop_name, setShop_name] = useState("");
    const [toastError, setToastError] = useState(false);
    const [errorMsg, setErrorMsg] = useState("");
    const [toastErrMsg, setToastErrMsg] = useState("");
    const [loading, setLoading] = useState(false);
    const [files, setFiles] = useState([]);
    const toggleActive = useCallback(() => {
        setFiles([]);
        setActive((active) => !active);
        setErrorMsg("");
    }, []);
    const handleDropZoneDrop = useCallback(
        (dropFiles, acceptedFiles, rejectedFiles) => {
            if (files.length === 0) {
                setFiles([...acceptedFiles]);
            } else {
                setFiles([...acceptedFiles]);
            }
        },
        [files]
    );

    const handleCancel = useCallback(
        (dropFiles, acceptedFiles, rejectedFiles) => {
            if (files.length > 0) {
                setFiles([]);
                setErrorMsg("");
            } else if (files.length === 0) {
                toggleActive();
            }
        },
        [files]
    );
    const validation = () => {
        if (files?.length === 0) {
            return "Please select a file";
        } else if (
            files[0]?.type !== "text/csv" &&
            files[0]?.type !==
                "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
        ) {
            return "Only CSV and XLSX formats are accepted";
        } else {
            return "success";
        }
    };
    const toggleActiveToast = useCallback(
        () => setToastActive((toastActive) => !toastActive),
        []
    );
    const errorActiveToast = useCallback(
        () => setToastError((toastError) => !toastError),
        []
    );
    const fetch = useAuthenticatedFetch();
    const exportComponent = async () => {
        let validated = validation();
        if (validated != "success") {
            setErrorMsg(validated);
        } else {
            setErrorMsg("");
            setToastErrMsg("");
            setLoading(true);
            const formData = new FormData();
            formData.append("file", files[0]);
            try {
                const response = await fetch(API_URL.importComponent, {
                    method: "POST",
                    body: formData,
                });
                const data = await response.json();
                console.log(data.status_code,"--code")
                console.log(data,"---data");
                
                setLoading(false);
                if (data.status === "success") {
                   
                    toggleActiveToast();
                    setTimeout(() => {
                        toggleActive();
                    }, 500);
                    setTimeout(() => {
                        Components(shop_name);
                    }, 1000);
                } else if (data.status_code == 409) {
                    errorActiveToast();
                    setToastErrMsg("Failed to import due to duplicate entries");
                    setFiles([]);
                } else {
                    errorActiveToast();
                    setToastErrMsg("Failed to import Componets");
                    setFiles([]);
                }
            } catch (err) {
                console.log(err,"----errr")
                errorActiveToast();
                setToastErrMsg("Failed to import Componets");
                setFiles([]);
                setLoading(false);
            }
        }
    };
    useEffect(() => {
        getShopName(fetch)
            .then((data) => {
                setShop_name(data.shop_name);
            })
            .catch((err) => {});
    }, [shop_name]);
    const validImageTypes = ["csv", "xlsx", "xls"];

    const fileUpload = files.length === 0 && (
        <DropZone.FileUpload
            actionHint="Accepts .csv  files only"
            allowMultiple={false}
        />
    );

    const uploadedFiles = files.length > 0 && (
        <div style={{ padding: "0" }}>
            <LegacyStack vertical>
                {files.map((file, index) => (
                    <LegacyStack alignment="center" key={index}>
                        <Thumbnail
                            size="small"
                            alt={file.name}
                            source={
                                validImageTypes.includes(file.type)
                                    ? window.URL.createObjectURL(file)
                                    : NoteIcon
                            }
                        />
                        <div>
                            {file.name}{" "}
                            <p className="Polaris-TextStyle--sizeSmall">
                                {file.size} bytes
                            </p>
                        </div>
                    </LegacyStack>
                ))}
            </LegacyStack>
        </div>
    );
    return (
        <div style={{ height: "500px" }}>
            <Frame>
                <Modal
                    size="large"
                    open={active}
                    onClose={toggleActive}
                    title="Import Components by CSV"
                    primaryAction={{
                        content: "Import Components",
                        loading: loading,
                        onAction: exportComponent,
                    }}
                    secondaryActions={[
                        {
                            content: "Cancel",
                            onAction: handleCancel,
                        },
                    ]}
                >
                    <Modal.Section>
                        {errorMsg !== "" && <InlineError message={errorMsg} />}
                        <BlockStack vertical>
                            <DropZone
                                onDrop={handleDropZoneDrop}
                                allowMultiple={false}
                            >
                                {uploadedFiles}
                                {fileUpload}
                            </DropZone>
                            {/* <Checkbox
                                checked={checked}
                                label="Overwrite existing components that have the same email or phone"
                                // onChange={handleCheckbox}
                            /> */}
                        </BlockStack>
                    </Modal.Section>
                </Modal>
                {toastActive && (
                    <SuccessToast
                        ToastMsg="File imported Successfully"
                        toggleActiveToast={toggleActiveToast}
                    />
                )}
                {toastError && (
                    <ErrorToast
                        ToastMsg={toastErrMsg}
                        errorActiveToast={errorActiveToast}
                    />
                )}
            </Frame>
        </div>
    );
}
