import { Button, Frame, Modal } from "@shopify/polaris";
import { useState, useCallback } from "react";
import { API_URL } from "../utils/apiUrls";
import { useAuthenticatedFetch } from "../hooks";
import SuccessToast from "./SuccessToast";
import ErrorToast from "./ErrorToast";
export default function RemoveModal({
    active,
    handleChange,
    product_id,
    shop_name,
    optionId,
    getOptionDetails,
}) {
    const fetch = useAuthenticatedFetch();
    const [toggleActive, settoggleActive] = useState(false);
    const toggleActiveToast = useCallback(() => {
        settoggleActive((toggleActive) => !toggleActive);
    }, []);
    const [toastError, setToastError] = useState(false);
    const [loading, setLoading] = useState(false);
    const errorActiveToast = useCallback(
        () => setToastError((toastError) => !toastError),
        []
    );
    const removeAssignedProducts = async () => {
        setLoading(true);
        const formData = new FormData();
        formData.append("shop_name", shop_name);
        formData.append("product_id", product_id);
        formData.append("option_id", optionId);
        try {
            const response = await fetch(API_URL.removeAssignedProducts, {
                method: "POST",
                body: formData,
            });
            const data = await response.json();
            setLoading(false);
            if (data.status === "success") {
                getOptionDetails(shop_name);
                toggleActiveToast();
                handleChange();
            }
        } catch (err) {}
    };

    return (
        <Frame>
            <Modal
                open={active}
                onClose={handleChange}
                title="Remove Assigned Product"
                primaryAction={{
                    content: "Yes",
                    loading: loading,
                    onAction: removeAssignedProducts,
                }}
                secondaryActions={[
                    {
                        content: "No",
                        onAction: handleChange,
                    },
                ]}
            >
                <Modal.Section>
                    <p>
                        Are You Sure You Want To Remove This Assigned Product?
                    </p>
                </Modal.Section>
            </Modal>
            {toggleActive && (
                <SuccessToast
                    ToastMsg="Removed Successfully"
                    toggleActiveToast={toggleActiveToast}
                />
            )}
            {toastError && (
                <ErrorToast
                    ToastMsg="Something Went Wrong"
                    errorActiveToast={errorActiveToast}
                />
            )}
        </Frame>
    );
}
