import { Listbox, Combobox, Icon } from "@shopify/polaris";
import { SearchIcon } from "@shopify/polaris-icons";
import { useState, useCallback, useMemo, useEffect } from "react";

export default function SelectSKU({
    SKUOptions,
    onSKUChange,
    cardIndex,
    index,
    selectedSKU,
    customKey,
    setInputs,
    inputs,
}) {
    const deselectedOptions = useMemo(() => SKUOptions, [SKUOptions]);
    const [selectedOption, setSelectedOption] = useState();
    const [inputValue, setInputValue] = useState("");
    const [options, setOptions] = useState(deselectedOptions);
    const [loading, setLoading] = useState(false);

    const escapeSpecialRegExCharacters = useCallback(
        (value) => value.replace(/[.*+?^${}()|[\]\\]/g, "\\$&"),
        []
    );
    const updateText = useCallback(
        (value) => {
            setInputValue(value);

            if (!loading) {
                setLoading(true);
            }

            setTimeout(() => {
                if (value === "") {
                    setOptions(deselectedOptions);
                    setLoading(false);
                    return;
                }
                const filterRegex = new RegExp(
                    escapeSpecialRegExCharacters(value),
                    "i"
                );
                const resultOptions = options.filter((option) =>
                    option.label.match(filterRegex)
                );
                setOptions(resultOptions);
                setLoading(false);
            }, 300);
        },
        [deselectedOptions, loading, options, escapeSpecialRegExCharacters]
    );
    useEffect(() => {
        setOptions(deselectedOptions);
    }, [deselectedOptions]);
    useEffect(() => {
        if (selectedSKU !== undefined) {
            setInputValue(selectedSKU);
            setSelectedOption(selectedSKU);
        }
    }, [selectedSKU]);

    const updateSelection = useCallback(
        (selected) => {
            const matchedOption = options.find((option) => {
                return option.value.match(selected);
            });
            onSKUChange(selected);
            setSelectedOption(selected);
            setInputValue((matchedOption && matchedOption.label) || "");
            setInputs((prevInputs) => {
                const newInputs = [...prevInputs];
                console.log(newInputs, "---newInputs");
                newInputs[cardIndex][index][customKey] = selected;
                return newInputs;
            });
        },
        [options]
    );

    const optionsMarkup =
        options.length > 0
            ? options.map((option) => {
                  const { label, value } = option;

                  return (
                      <Listbox.Option
                          key={`${value}`}
                          value={value}
                          selected={selectedOption === value}
                          accessibilityLabel={label}
                      >
                          {label}
                      </Listbox.Option>
                  );
              })
            : null;

    const loadingMarkup = loading ? (
        <Listbox.Loading accessibilityLabel="Loading" />
    ) : null;

    const listboxMarkup =
        optionsMarkup || loadingMarkup ? (
            <Listbox onSelect={updateSelection}>
                {optionsMarkup && !loading ? optionsMarkup : null}
                {loadingMarkup}
            </Listbox>
        ) : null;

    return (
        <Combobox
            activator={
                <Combobox.TextField
                    prefix={<Icon source={SearchIcon} />}
                    onChange={updateText}
                    label="Search SKUs"
                    labelHidden
                    value={inputValue}
                    placeholder="Search SKUs"
                    autoComplete="off"
                />
            }
        >
            {listboxMarkup}
        </Combobox>
    );
}
