import {
    Button,
    IndexTable,
    Card,
    IndexFilters,
    useIndexResourceState,
    useSetIndexFiltersMode,
    BlockStack,
    useBreakpoints,
    Pagination,
    Box,
} from "@shopify/polaris";

import { useState, useCallback, useEffect } from "react";
import { useFilteredData } from "../hooks";
import { useParams } from "react-router-dom";
import RemoveModal from "./RemoveModal";
export default function ProductsAssignTable({
    rows,
    shop_name,
    getOptionDetails,
}) {
    const [selected, setSelected] = useState(0);
    const [currentPage, setCurrentPage] = useState(1);
    const [totalPages, setTotalPages] = useState();
    const { mode, setMode } = useSetIndexFiltersMode();
    const [product_id, setProduct_id] = useState();
    const PageSize = 5;

    const [active, setActive] = useState(false);

    const handleChange = useCallback(() => setActive(!active), [active]);
    const optionId = useParams().idx;
    const sortOptions = [
        {
            label: "none",
            value: "none asc",
            directionLabel: "A-Z",
        },
        {
            label: "none",
            value: "none desc",
            directionLabel: "Z-A",
        },
        {
            label: "Product Name",
            value: "product asc",
            directionLabel: "A-Z",
        },
        {
            label: "Product Name",
            value: "product desc",
            directionLabel: "Z-A",
        },
    ];
    const [sortSelected, setSortSelected] = useState(["none asc"]);

    const onHandleCancel = () => {};

    const [queryValue, setQueryValue] = useState("");

    const handleFiltersQueryChange = useCallback(
        (value) => {
            let filteredRows = rows.filter((item) =>
                item.product_name?.toLowerCase()?.includes(value.toLowerCase())
            );
            const totalPagesRounded = Math.ceil(filteredRows.length / PageSize);
            if (totalPagesRounded === 0) {
                setTotalPages(1);
                setCurrentPage(1);
            } else {
                setTotalPages(totalPagesRounded);
                setCurrentPage(1);
            }
            setQueryValue(value);
        },
        [rows, PageSize, currentPage, totalPages]
    );
    const handleAccountStatusRemove = useCallback(
        () => setAccountStatus(undefined),
        []
    );
    const handleMoneySpentRemove = useCallback(
        () => setMoneySpent(undefined),
        []
    );
    const handleTaggedWithRemove = useCallback(() => setTaggedWith(""), []);
    const handleQueryValueRemove = useCallback(() => setQueryValue(""), []);
    const handleFiltersClearAll = useCallback(() => {
        handleAccountStatusRemove();
        handleMoneySpentRemove();
        handleTaggedWithRemove();
        handleQueryValueRemove();
    }, [
        handleAccountStatusRemove,
        handleMoneySpentRemove,
        handleQueryValueRemove,
        handleTaggedWithRemove,
    ]);
    const handleNext = () => {
        setCurrentPage((prevPage) => prevPage + 1);
    };
    const handlePrevious = () => {
        setCurrentPage((prevPage) => prevPage - 1);
    };
    const resourceName = {
        singular: "products",
        plural: "products",
    };

    useEffect(() => {
        const totalPagesRounded = Math.ceil(rows?.length / PageSize);
        if (totalPagesRounded === 0) {
            setTotalPages(1);
            setCurrentPage(1);
        } else {
            setTotalPages(Math.ceil(rows?.length / PageSize));
            setCurrentPage(1);
        }
    }, [PageSize, rows]);
    const { selectedResources, allResourcesSelected, handleSelectionChange } =
        useIndexResourceState(rows);
    const filteredData =
        rows.length > 0
            ? useFilteredData(
                  rows,
                  queryValue,
                  sortSelected,
                  currentPage,
                  PageSize
              )
            : [];
    const rowMarkup = filteredData?.map(
        ({ id, product_name, product_id }, index) => (
            <IndexTable.Row
                id={id}
                key={id}
                selected={selectedResources.includes(id)}
                position={index}
            >
                <IndexTable.Cell>{product_name}</IndexTable.Cell>
                <IndexTable.Cell>
                    <Button
                        variant="primary"
                        onClick={() => {
                            setProduct_id(product_id);
                            handleChange();
                        }}
                    >
                        Remove
                    </Button>
                </IndexTable.Cell>
            </IndexTable.Row>
        )
    );

    return (
        <>
            <Card>
                <IndexFilters
                    sortOptions={sortOptions}
                    sortSelected={sortSelected}
                    queryValue={queryValue}
                    queryPlaceholder="Searching in all"
                    onQueryChange={handleFiltersQueryChange}
                    onQueryClear={() => setQueryValue("")}
                    onSort={setSortSelected}
                    cancelAction={{
                        onAction: onHandleCancel,
                        disabled: false,
                        loading: false,
                    }}
                    tabs={[]}
                    selected={selected}
                    onSelect={setSelected}
                    canCreateNewView={false}
                    filters={[]}
                    appliedFilters={[]}
                    mode={mode}
                    setMode={setMode}
                    onClearAll={handleFiltersClearAll}
                />
                <IndexTable
                    selectable={false}
                    condensed={useBreakpoints().smDown}
                    resourceName={resourceName}
                    itemCount={filteredData.length}
                    selectedItemsCount={
                        allResourcesSelected ? "All" : selectedResources.length
                    }
                    onSelectionChange={handleSelectionChange}
                    headings={[{ title: "Product Name" }, { title: "Action" }]}
                >
                    {rowMarkup}
                </IndexTable>
                <Box padding={"300"}>
                    <BlockStack inlineAlign="center">
                        {rows?.length > PageSize && (
                            <Pagination
                                hasPrevious={currentPage !== 1}
                                onPrevious={handlePrevious}
                                hasNext={totalPages > currentPage}
                                onNext={handleNext}
                            />
                        )}
                    </BlockStack>
                </Box>
            </Card>
            {active && (
                <RemoveModal
                    active={active}
                    handleChange={handleChange}
                    optionId={optionId}
                    shop_name={shop_name}
                    product_id={product_id}
                    getOptionDetails={getOptionDetails}
                />
            )}
        </>
    );
}
