import {
    Frame,
    Page,
    Layout,
    Card,
    FormLayout,
    BlockStack,
    TextField,
    InlineStack,
    Box,
    Text,
    Icon,
    InlineError,
    Button,
    ButtonGroup,
} from "@shopify/polaris";
import { useState, useEffect, useCallback } from "react";
import { PlusCircleIcon, MinusCircleIcon } from "@shopify/polaris-icons";
import { useAuthenticatedFetch } from "../hooks";
import AddOption from "../components/AddOption";
import SelectOptions from "../components/SelectOptions";
import { API_URL } from "../utils/apiUrls";
import { getShopName } from "../utils/shopName";
import SuccessToast from "../components/SuccessToast";
import { useNavigate } from "react-router-dom";
import SelectSKU from "../components/SelectSKU";
export default function CreateOptions() {
    const [active, setActive] = useState(false);
    const [createdOptions, setCreatedOptions] = useState([]);
    const [selectedSKU, setSelectedSKU] = useState("");
    const [errorMsg, setErrorMsg] = useState([]);
    const [selectedOption, setSelectedOption] = useState();
    const [shop_name, setShop_name] = useState("");
    const [SKUOptions, setSKUOptions] = useState([]);
    const [isLoading, setIsLoading] = useState(false);
    const [cardCount, setCardCount] = useState(1);
    const [toggleActive, settoggleActive] = useState(false);
    const navigate = useNavigate();
    const toggleActiveToast = useCallback(() => {
        settoggleActive((toggleActive) => !toggleActive);
    }, []);
    const [values, setValues] = useState(
        Array(cardCount).fill({ value: "", sku: "", qty: "" })
    );
    const handleChange = useCallback(() => {
        setActive(!active), [active];
    });
    const [inputs, setInputs] = useState(
        Array(cardCount).fill([{ sku: "", qty: "" }])
    );
    const handleOptionsChange = (data) => {
        setSelectedOption(data);
    };

    const fetch = useAuthenticatedFetch();

    const handleAddCard = () => {
        setErrorMsg("");
        setCardCount((prevCount) => prevCount + 1);
        setValues((prevValues) => [
            ...prevValues,
            { value: "", sku: "", qty: "" },
        ]);
        setInputs((prevInputs) => [...prevInputs, [{ sku: "", qty: "" }]]);
    };
    const onSKUChange = (data) => {
        setSelectedSKU(data);
    };

    const handleRemoveCard = () => {
        setErrorMsg("");
        if (cardCount > 0) {
            setCardCount((prevCount) => prevCount - 1);
            setValues((prevValues) => prevValues.slice(0, -1));
            setInputs((prevInputs) => prevInputs.slice(0, -1));
        }
    };
    const getSKU = async (shop_name) => {
        try {
            const response = await fetch(
                `${API_URL.getComponents}?shop_name=${shop_name}`
            );
            const data = await response.json();
            if (data.status == "success") {
                const formattedSKU = data?.data?.map((sku) => ({
                    label: `${sku?.component_sku}`,
                    value: sku?.component_sku,
                }));
                setSKUOptions(formattedSKU);
            } else {
                const formattedSKU = [
                    {
                        label: "No SKU",
                        value: 1,
                    },
                ];
                setSKUOptions(formattedSKU);
            }
        } catch (err) {}
    };
    const getOption = async (shop_name) => {
        try {
            const response = await fetch(
                API_URL.getOptions + `?shop_name=${shop_name}`
            );

            const data = await response.json();
            if (data?.data?.length > 0) {
                const formattedOptions = data?.data?.map((option) => ({
                    label: `${option?.option_name}`,
                    value: option?.id,
                }));
                setCreatedOptions(formattedOptions);
            } else {
                const formattedOptions = [
                    {
                        label: "No Options",
                        value: 1,
                    },
                ];
                setCreatedOptions(formattedOptions);
            }
        } catch (err) {}
    };
    const addInput = (cardIndex) => {
        setErrorMsg("");
        const newInputs = [...inputs];
        newInputs[cardIndex] = [...newInputs[cardIndex], { sku: "", qty: "" }];
        setInputs(newInputs);
    };
    const removeInput = (cardIndex, index) => {
        setErrorMsg("");
        const newInputs = [...inputs];
        newInputs[cardIndex].splice(index, 1);
        setInputs(newInputs);
    };

    const handleInputChange = (cardIndex, index, value, key) => {
        const newInputs = [...inputs];
        newInputs[cardIndex][index][key] = value;
        setInputs(newInputs);
        setErrorMsg("");
    };

    const handleValueChange = (newValue, cardIndex) => {
        const newValues = [...values];
        newValues[cardIndex] = { ...newValues[cardIndex], value: newValue };
        setValues(newValues);
        setErrorMsg("");
    };

    const validation = () => {
        let missingSKU = false;
        let missingQTY = false;
        let missing = "";
        inputs.forEach((val, index) => {
            val.map((value, indexSku) => {
                if (value.sku === "" || value.sku === undefined) {
                    missingSKU = true;
                }
            });
        });
        inputs.forEach((val, index) => {
            val.map((value, indexSku) => {
                if (value.qty === "" || value.qty === undefined) {
                    missingQTY = true;
                }
            });
        });
        if (selectedOption == "" || selectedOption == undefined) {
            return "Please Select Option ";
        } else if (
            values.some(
                (val, index) => val.value == "" || val.value == undefined
            )
        ) {
            values.map((val, index) => {
                if (
                    index === 0 &&
                    (val.value === "" || val.value === undefined)
                ) {
                    missing += "At-least one value is required";
                }
                if (
                    index !== 0 &&
                    (val.value === "" || val.value === undefined)
                ) {
                    missing +=
                        "Empty value is not allowed please remove it or fill it";
                }
            });
        } else if (missingSKU) {
            values.map((item, cardIndex) => {
                inputs[cardIndex].forEach((valSku) => {
                    if (valSku.sku === "" || valSku.sku === undefined) {
                        missing +=
                            "Please enter the sku for value:  " + item.value;
                    }
                });
            });
        } else if (missingQTY) {
            inputs.forEach((val) => {
                val.map((valQty) => {
                    if (valQty.qty === "" || valQty.qty === undefined) {
                        missing += "Please enter the Qty for SKU:" + valQty.sku;
                    }
                });
            });
        } else {
            missing += "";
        }
        if (missing !== "") {
            return missing;
        } else {
            return "success";
        }
    };
    const createOptionsForProduct = async () => {
        let validated = validation();
        if (validated != "success") {
            setErrorMsg([validated]);
        } else {
            setIsLoading(true);
            setErrorMsg("");
            const body = {
                shop_name: shop_name,
                option_details: [
                    {
                        option_id: selectedOption,
                        values: values.map((val, cardIndex) => {
                            return {
                                name: val.value,
                                components: inputs[cardIndex].map((input) => {
                                    return {
                                        SKU: input.sku,
                                        Quantity: input.qty,
                                    };
                                }),
                            };
                        }),
                    },
                ],
            };
            try {
                const response = await fetch(API_URL.createOption, {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                    },
                    body: JSON.stringify(body),
                });

                const data = await response.json();
                setIsLoading(false);
                if (data.status === "success") {
                    toggleActiveToast();
                    setTimeout(() => {
                        navigate("/product-options");
                    }, 1000);
                } else {
                    setErrorMsg(data.message);
                }
            } catch (err) {
                setIsLoading(false);
            }
        }
    };
    useEffect(() => {
        getShopName(fetch)
            .then((data) => {
                getOption(data.shop_name);
                setShop_name(data.shop_name);
                getSKU(data.shop_name);
            })
            .catch((err) => {});
    }, []);

    return (
        <Frame>
            <Page
                fullWidth
                backAction={{ content: "Products", url: "/product-options" }}
                title="Create Options"
                primaryAction={{
                    content: "Add New Option Name",
                    onClick: () => {
                        handleChange();
                    },
                }}
            >
                <Layout>
                    <Layout.Section variant="oneThird"></Layout.Section>
                    <Layout.Section variant="oneThird">
                        <Box padding={"800"}>
                            <Text id="option" variant="headingMd" as="h4">
                                Option Name
                            </Text>
                        </Box>
                        <Box padding={"800"}></Box>
                        {values.map((val, cardIndex) => (
                            <>
                                <Box padding={"1000"}>
                                    <Text
                                        id="option"
                                        variant="headingMd"
                                        as="h4"
                                    >
                                        Value for the Option Selected
                                    </Text>
                                </Box>

                                <Box padding={"800"}>
                                    <Text
                                        id="option"
                                        variant="headingMd"
                                        as="h4"
                                    >
                                        Component QTY & Component SKU
                                    </Text>
                                </Box>
                                <Box padding={"800"}></Box>
                                <Box padding={"400"}></Box>
                            </>
                        ))}
                    </Layout.Section>
                    <Layout.Section>
                        <FormLayout>
                            <Card>
                                <Box padding={"400"}>
                                    <SelectOptions
                                        createdOptions={createdOptions}
                                        onOptionsChange={handleOptionsChange}
                                    />
                                </Box>
                            </Card>
                        </FormLayout>

                        {[...Array(cardCount)].map((_, cardIndex) => (
                            <div style={{ paddingTop: "40px" }} key={cardIndex}>
                                <Card>
                                    <Box padding={"400"}>
                                        <Text>Value</Text>
                                        <TextField
                                            labelHidden
                                            value={values[cardIndex]?.value}
                                            onChange={(e) => {
                                                handleValueChange(e, cardIndex);
                                            }}
                                            autoComplete="off"
                                            placeholder="Enter Value"
                                        />
                                    </Box>
                                    <Box padding={"100"}></Box>
                                    <InlineStack gap={"1200"} align="center">
                                        {inputs[cardIndex].map(
                                            (input, index) => (
                                                <span key={index}>
                                                    <BlockStack>
                                                        <Box padding={"200"}>
                                                            <Text
                                                                id="option"
                                                                variant="subdued"
                                                                as="h1"
                                                            >
                                                                Component{" "}
                                                                {index + 1} SKU
                                                            </Text>
                                                        </Box>
                                                        <div>
                                                            <SelectSKU
                                                                SKUOptions={
                                                                    SKUOptions
                                                                }
                                                                onSKUChange={
                                                                    onSKUChange
                                                                }
                                                                cardIndex={
                                                                    cardIndex
                                                                }
                                                                customKey="sku"
                                                                index={index}
                                                                setInputs={
                                                                    setInputs
                                                                }
                                                                inputs={inputs}
                                                                selectedSKU={
                                                                    input.sku
                                                                }
                                                            />
                                                        </div>
                                                    </BlockStack>
                                                    <BlockStack>
                                                        <Box padding={"200"}>
                                                            <Text
                                                                id="option"
                                                                variant="subdued"
                                                                as="h1"
                                                            >
                                                                Component{" "}
                                                                {index + 1} QTY
                                                            </Text>
                                                        </Box>
                                                        <TextField
                                                            labelHidden
                                                            type="number"
                                                            value={input.qty}
                                                            onChange={(e) =>
                                                                handleInputChange(
                                                                    cardIndex,
                                                                    index,
                                                                    e,
                                                                    "qty"
                                                                )
                                                            }
                                                            autoComplete="off"
                                                        />
                                                        <div className="icons">
                                                            {inputs[cardIndex]
                                                                ?.length >
                                                                1 && (
                                                                <span
                                                                    onClick={() =>
                                                                        removeInput(
                                                                            cardIndex,
                                                                            index
                                                                        )
                                                                    }
                                                                >
                                                                    <Icon
                                                                        source={
                                                                            MinusCircleIcon
                                                                        }
                                                                    />
                                                                </span>
                                                            )}
                                                            {index ===
                                                                inputs[
                                                                    cardIndex
                                                                ].length -
                                                                    1 && (
                                                                <span
                                                                    onClick={() =>
                                                                        addInput(
                                                                            cardIndex
                                                                        )
                                                                    }
                                                                >
                                                                    <Icon
                                                                        source={
                                                                            PlusCircleIcon
                                                                        }
                                                                    />
                                                                </span>
                                                            )}
                                                        </div>
                                                    </BlockStack>
                                                </span>
                                            )
                                        )}
                                    </InlineStack>
                                </Card>
                            </div>
                        ))}

                        <BlockStack inlineAlign="start">
                            <Box padding={"200"}>
                                <ButtonGroup>
                                    <Button
                                        variant="primary"
                                        onClick={handleAddCard}
                                    >
                                        Add Value
                                    </Button>
                                    {cardCount > 1 && (
                                        <Button
                                            variant="primary"
                                            onClick={handleRemoveCard}
                                        >
                                            Remove Value
                                        </Button>
                                    )}
                                </ButtonGroup>
                            </Box>
                            {errorMsg?.length > 0 &&
                                errorMsg?.map((val, index) => {
                                    return (
                                        <InlineError
                                            message={val}
                                            fieldID={index}
                                        />
                                    );
                                })}
                        </BlockStack>
                        <BlockStack inlineAlign="end">
                            <Box padding={"600"}>
                                <Button
                                    variant="primary"
                                    loading={isLoading}
                                    onClick={createOptionsForProduct}
                                >
                                    Save
                                </Button>
                            </Box>
                        </BlockStack>
                    </Layout.Section>
                    <Layout.Section variant="oneThird"></Layout.Section>
                </Layout>
            </Page>
            {active && (
                <AddOption
                    active={active}
                    setActive={setActive}
                    getOption={getOption}
                />
            )}
            {toggleActive && (
                <SuccessToast
                    ToastMsg="Option Created Successfully"
                    toggleActiveToast={toggleActiveToast}
                />
            )}
        </Frame>
    );
}
