import { Frame, Page, BlockStack, Spinner } from "@shopify/polaris";
import { useState, useEffect } from "react";
import { API_URL } from "../utils/apiUrls";
import { useAuthenticatedFetch } from "../hooks/useAuthenticatedFetch";
import ImportComponent from "../components/ImportComponent";
import AddComponent from "../components/AddComponent";
import { getShopName } from "../utils/shopName";
import ComponentTable from "../components/ComponentTable";
import EmptyStateComponent from "../components/EmptyState";

export default function HomePage() {
    const [rows, setRows] = useState([]);
    const [active, setActive] = useState(false);
    const [loading, setLoading] = useState(false);
    const [emptyStatus, setEmptyStatus] = useState(false);
    const fetch = useAuthenticatedFetch();
    const [addComponentActive, setAddComponentActive] = useState(false);
    const [value, setValue] = useState({
        sku: "",
        name: "",
        qty: "",
        stock: "",
    });

    const handleChange = (val, type) => {
        setValue({
            ...value,
            [type]: val,
        });
    };

    const Components = async (shop_name) => {
        setLoading(true);
        try {
            const response = await fetch(
                API_URL.getComponents + `?shop_name=${shop_name}`
            );
            const data = await response.json();
            if (data.status === "success") {
                setRows(data.data);
                setLoading(false);
                setEmptyStatus(false);
            } else if (data.status === "error") {
                setLoading(false);
                setEmptyStatus(true);
            }
        } catch (err) {
            setLoading(false);
            setEmptyStatus(false);
        }
    };
    const handleAddComponent = () => {
        setAddComponentActive(true);
        setValue({ sku: "", name: "", qty: "", stock: "" });
    };

    const handleImportComponent = () => {
        setActive(true);
    };
    useEffect(() => {
        getShopName(fetch)
            .then((data) => {
                Components(data.shop_name);
            })
            .catch((err) => {});
    }, []);
    return (
        <Frame>
            <Page
                fullWidth
                title="Component Stock Table"
                primaryAction={{
                    content: "Add Component",
                    onClick: handleAddComponent,
                }}
                secondaryActions={[
                    {
                        content: "Import",
                        onClick: handleImportComponent,
                    },
                ]}
            >
                {loading && (
                    <div style={{ marginTop: "200px" }}>
                        <BlockStack inlineAlign="center">
                            <Spinner />
                        </BlockStack>
                    </div>
                )}
                {rows && rows.length > 0 && !emptyStatus && !loading && (
                    <ComponentTable rows={rows} Components={Components} />
                )}
                {emptyStatus && !loading && (
                    <EmptyStateComponent heading="No Components" />
                )}
                {active && (
                    <ImportComponent
                        active={active}
                        setActive={setActive}
                        Components={Components}
                    />
                )}
                {addComponentActive && (
                    <AddComponent
                        addComponentActive={addComponentActive}
                        setAddComponentActive={setAddComponentActive}
                        value={value}
                        handleChange={handleChange}
                        Components={Components}
                    />
                )}
            </Page>
        </Frame>
    );
}
