import { Frame, Page, BlockStack, Spinner } from "@shopify/polaris";
import { useState, useEffect } from "react";
import { useAuthenticatedFetch } from "../hooks/useAuthenticatedFetch";
import { getShopName } from "../utils/shopName";
import EmptyStateComponent from "../components/EmptyState";
import { useNavigate } from "react-router-dom";
import OptionsTable from "../components/OptionsTable";
import { API_URL } from "../utils/apiUrls";
export default function ProductOptions() {
    const [rows, setRows] = useState([]);
    const [loading, setLoading] = useState(false);
    const [emptyStatus, setEmptyStatus] = useState(false);
    const fetch = useAuthenticatedFetch();

    const navigate = useNavigate();
    const getOption = async (shop_name) => {
        setLoading(true);

        try {
            const response = await fetch(
                API_URL.getOptions + `?shop_name=${shop_name}`
            );
            setLoading(false);
            const data = await response.json();

            if (data?.data?.length > 0) {
                setRows(data.data);
            } else {
                setEmptyStatus(true);
            }
        } catch (err) {}
    };

    useEffect(() => {
        getShopName(fetch)
            .then((data) => {
                getOption(data.shop_name);
            })
            .catch((err) => {});
    }, []);

    return (
        <Frame>
            <Page
                fullWidth
                title="Product Options"
                primaryAction={{
                    content: "Create",
                    onClick: () => {
                        navigate("/create-options");
                    },
                }}
            >
                {loading && (
                    <div style={{ marginTop: "200px" }}>
                        <BlockStack inlineAlign="center">
                            <Spinner />
                        </BlockStack>
                    </div>
                )}
                {rows && rows.length > 0 && !emptyStatus && !loading && (
                    <OptionsTable rows={rows} getOption={getOption} />
                )}
                <div
                    style={{
                        margin: "20px auto",
                        paddingLeft: "150px",
                        paddingRight: "150px",
                    }}
                >
                    {emptyStatus && !loading && (
                        <EmptyStateComponent heading="No Options" />
                    )}
                </div>
            </Page>
        </Frame>
    );
}
