<?php

use App\Http\Controllers\ComponentController;
use App\Http\Controllers\ImportComponentController;
use App\Http\Controllers\OptionsController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::get('/', function () {
    return "Hello API";
});


Route::post('/file-import', [ImportComponentController::class, 'fileImport'])->name('file-import');

Route::get('/file-export', [ImportComponentController::class, 'fileExport'])->name('file-export');

Route::get('/get-components',[ComponentController::class,'componentView']);

Route::post('/create-components',[ComponentController::class,'createComponent']);
Route::post('/create-components-new',[ComponentController::class,'createComponentNew']);

Route::post('/edit-update-components',[ComponentController::class,'editComponent']);
Route::post('/edit-update-components-new',[ComponentController::class,'editComponentNew']);

Route::get('/delete-component',[ComponentController::class,'deleteComponent']);

// Options CRUD
Route::get('/get-options',[OptionsController::class,'getOptions']);

Route::post('/create-Option',[OptionsController::class,'createOptions']);

Route::post('/assign-mini-product-values-to-options',[OptionsController::class,'createMiniProductComponentAndProduct']);

Route::post('/assign-lookups',[OptionsController::class,'assignLookups']);

Route::post('/delete-option',[OptionsController::class,'deleteOption']);

Route::get('/option-details',[OptionsController::class,'optionDetails']);

Route::post('/edit-option',[OptionsController::class,'editOption']);

Route::get('/get-products',[OptionsController::class,'getProducts']);

Route::post('/remove-assigned-products',[OptionsController::class,'removeAssignedProducts']);

Route::get('/post-data',[OptionsController::class,'check']);

Route::get('/getOrderId',[ComponentController::class,'getOrderId']);

